//
//  Chap9.h
//  Sinc
//
//  Created by 杉浦 洋 on 2018/04/02.
//  Copyright © 2018年 杉浦 洋. All rights reserved.
//

#ifndef Chap9_h
#define Chap9_h
/*---------------------------------------*/
/*［９］正規分布モデル　　 　　　　 　　　　　　　*/
/*---------------------------------------*/
//グローバル階層確率表の初期化
/*階層確率表の計算はコストがかかるので，グローバルに確保する．*/
/*不必要な再計算は極力抑止する．　　　　　　　　　　　　　　　*/
int LevPrSinck=0;
double *LevPrSinclms;
double ***LevPrSincP;

//生存関数と分布関数
double BSvF(double t,int k,double *lms,int m){ /*生存関数BS(t|k,λ,m)*/
    double ***P,Sv;
    int lv,i,L;
    /*例外処理*/
    if(!(2<=k && k<=20)) {return NAN;};
    if(!(m>=2 || m==-1)) {return NAN;};
    if(t < 0) {return 0;};
    /*LevelProbability`Pの計算*/
    lv=0;
    if(k<=LevPrSinck) for(i=0;i<k;i++)lv+= lms[i]!=LevPrSinclms[i];
    if(k>LevPrSinck||lv){
        LevPrSinck=k;
        LevPrSinclms=&lms[0];
        LevPrSincP=MakeTableP(k,lms);
    };
    /*生存関数の計算*/
    P=LevPrSincP;
    Sv=0;
    for(L=2;L<=k;L++) Sv+=P[L][k][1]*FSvF(t/(L-1),L-1,m);
    return Sv;
};
double BCDF(double t,int k,double *lms,int m){ /*分布関数SB(t|k,λ,m)*/
    /*例外処理*/
    if(!(2<=k && k<=20)) {return NAN;};
    if(!(m>=2 || m==-1)) {return NAN;};
    if(t < 0) {return 0;};
    return 1-BSvF(t,k,lms,m);
};
double CSvF(double t,int k,double *lms){ /*生存関数CS(t|k,λ)*/
    int lv,i,L;
    double ***P,Sv;
    /*例外処理*/
    if(!(2<=k && k<=20)) {return NAN;};
    if(t < 0) {return 1;};
    /*階層確率表Pの計算*/
    lv=0;
    if(k<=LevPrSinck) for(i=0;i<k;i++)lv+= lms[i]!=LevPrSinclms[i];
    if(k>LevPrSinck||lv){
        LevPrSinck=k;
        LevPrSinclms=&lms[0];
        LevPrSincP=MakeTableP(k,lms);
    };
    /*生存関数の逆関数計算*/
    P=LevPrSincP;
    Sv=0;
    for(L=2;L<=k;L++) Sv+= P[L][k][1]*chi2SvF(t,L-1);
    return Sv;
};
double CCDF(double t,int k,double *lms){ /*分布関数SB(t|k,λ,m)*/
    if(!(2<=k && k<=20)) {return NAN;};
    if(t < 0) {return 0;};
    return 1-CSvF(t,k,lms);
};

//100α%点
double bbar2Fun(int k,double *lms,int m,double al){/*SB^(-1)(1-α|k,λ,m)*/
    if(!(2<=k && k<=20)||!(1.0e-8<=al && al<=0.5)) return NAN;
    if(m<2) return NAN;
    return SecantNormalB(BCDF,k,lms,m,al);
};
double cbar2Fun(int k,double *lms,double al){/*SC^(-1)(1-α|k,λ,m)*/
    if(!(2<=k && k<=20)||!(1.0e-8<=al && al<=0.5)) return NAN;
    return SecantNormalC(CCDF,k,lms,al);
};

//表配列(T1型)
double** bbarTab(int k,int m,double al){/*bbar2FunのT1型(k+1)×(k+1)2次元表配列tab*/
    /*tab[M][l]=bbar2Fun(k,lms,m,alMl(al,M,l)), lms={1,1,...,1}*/
    double **tab,*lms;
    int i,M,l,lv;
    /*tab配列の確保*/
    tab=malloc((k+1)*sizeof(double *));
    for(i=0;i<=k;i++){
        tab[i]=malloc((k+1)*sizeof(double));
    };
    for(M=0;M<=k;M++){
        for(l=0;l<=k;l++) tab[M][l] = NAN;
    };
    /*階層確率の計算*/
    lms=malloc(k*sizeof(double));
    for(i=0;i<k;i++) lms[i]=1.0;
    /*階層確率表Pの計算*/
    lv=0;
    if(k<=LevPrSinck) for(i=0;i<k;i++)lv+= lms[i]!=LevPrSinclms[i];
    if(k>LevPrSinck||lv){
        LevPrSinck=k;
        LevPrSinclms=&lms[0];
        LevPrSincP=MakeTableP(k,lms);
    };
    /*表配列tabの計算*/
    for(M=2;M<=k;M++){
        for(l=2;l<=M;l++){
            if(l!=M-1) tab[M][l] = bbar2Fun(l,lms,m,alMl(al,M,l));
        };
    };
    return tab;
};
double** cbarTab(int k,double al){/*cbar2FunのT1型(k+1)×(k+1)2次元表配列tab*/
    /*tab[M][l]=cbar2Fun(k,lms,alMl(al,M,l)), lms={1,1,...,1}*/
    double **tab,*lms;
    int i,M,l,lv;
    /*tab配列の確保*/
    tab=malloc((k+1)*sizeof(double *));
    for(i=0;i<=k;i++){
        tab[i]=malloc((k+1)*sizeof(double));
    };
    for(M=0;M<=k;M++){
        for(l=0;l<=k;l++) tab[M][l] = NAN;
    };
    /*階層確率の重みベクトルの計算*/
    lms=malloc(k*sizeof(double));
    for(i=0;i<k;i++) lms[i]=1.0;
    /*階層確率表Pの計算*/
    lv=0;
    if(k<=LevPrSinck) for(i=0;i<k;i++)lv+= lms[i]!=LevPrSinclms[i];
    if(k>LevPrSinck||lv){
        LevPrSinck=k;
        LevPrSinclms=&lms[0];
        LevPrSincP=MakeTableP(k,lms);
    };
    /*表配列tabの計算*/
    for(i=0;i<k;i++) lms[i]=1.0;
    for(M=2;M<=k;M++){
        for(l=2;l<=M;l++){
            if(l!=M-1) tab[M][l] = cbar2Fun(l,lms,alMl(al,M,l));
        };
    };
    return tab;
}

//表関数(T3型)
double* bbar32Tab(int k,double *lms,int m,double al){
    double *tab;
    int l,lv,i;
    /*階層確率表Pの計算*/
    lv=0;
    if(k<=LevPrSinck) for(i=0;i<k;i++)lv+= lms[i]!=LevPrSinclms[i];
    if(k>LevPrSinck||lv){
        LevPrSinck=k;
        LevPrSinclms=&lms[0];
        LevPrSincP=MakeTableP(k,lms);
    };
    /*表配列tabの確保と計算*/
    tab = malloc((k+1)*sizeof(double));
    tab[0] = NAN;tab[k] = NAN;
    for(l=2;l<=k;l++) tab[l] = bbar2Fun(l,lms,m,al);
    return tab;
}
double* cbar32Tab(int k,double *lms,double al){
    double *tab;
    int l,lv,i;
    /*階層確率表Pの計算*/
    lv=0;
    if(k<=LevPrSinck) for(i=0;i<k;i++)lv+= lms[i]!=LevPrSinclms[i];
    if(k>LevPrSinck||lv){
        LevPrSinck=k;
        LevPrSinclms=&lms[0];
        LevPrSincP=MakeTableP(k,lms);
    };
    /*表配列tabの確保と計算*/
    tab = malloc((k+1)*sizeof(double));
    tab[0] = NAN;tab[k] = NAN;
    for(l=2;l<=k;l++) tab[l] = cbar2Fun(l,lms,al);
    return tab;
}
#endif /* Chap9_h */
